<?php
// admin/chat.php - view a conversation and send manual reply
$cfg = include __DIR__ . '/../config.php';
session_start();
if (!isset($_SESSION['admin_logged'])) { header('Location: index.php'); exit; }

$sender = $_GET['sender'] ?? null;
if (!$sender) { echo 'Missing sender'; exit; }

$messages_file = $cfg['MESSAGES_FILE'];
$messages = file_exists($messages_file) ? (json_decode(file_get_contents($messages_file), true) ?: []) : [];
$conv = $messages[$sender] ?? [];

// handle manual send
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['reply_text'])) {
    require_once __DIR__ . '/../fb_send.php';
    $reply = trim($_POST['reply_text']);
    if ($reply !== '') {
        // append to JSON
        $bot_record = ['sender' => 'bot', 'to' => $sender, 'timestamp' => time(), 'text' => $reply];
        $messages[$sender][] = $bot_record;
        file_put_contents($messages_file, json_encode($messages, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
        // send via FB
        fb_send_message($sender, $reply, $cfg);
        header('Location: chat.php?sender=' . urlencode($sender));
        exit;
    }
}

?>
<!doctype html>
<html>
<head><meta charset="utf-8"><title>Chat with <?php echo htmlspecialchars($sender); ?></title>
<style>body{font-family:Arial,sans-serif;margin:20px}.msg{border-radius:8px;padding:8px;margin:6px 0;max-width:70%} .from{background:#f1f1f1}.bot{background:#dff0d8;margin-left:auto;text-align:right}</style>
</head>
<body>
<p><a href="index.php">&larr; Back</a></p>
<h2>Chat: <?php echo htmlspecialchars($sender); ?></h2>
<div>
    <?php foreach ($conv as $m): ?>
        <?php if (($m['sender'] ?? '') === 'bot'): ?>
            <div class="msg bot"><strong>Bot:</strong><br><?php echo nl2br(htmlspecialchars($m['text'] ?? '')); ?><br><small><?php echo date('Y-m-d H:i:s', $m['timestamp'] ?? time()); ?></small></div>
        <?php else: ?>
            <div class="msg from"><strong>User:</strong><br><?php echo nl2br(htmlspecialchars($m['text'] ?? '')); ?><br><small><?php echo date('Y-m-d H:i:s', $m['timestamp'] ?? time()); ?></small></div>
        <?php endif; ?>
    <?php endforeach; ?>
</div>

<h3>Send manual reply</h3>
<form method="post">
    <textarea name="reply_text" rows="4" style="width:100%"></textarea><br>
    <button type="submit">Send</button>
</form>
</body>
</html>
