<?php
// admin/index.php - simple dashboard listing conversations
$cfg = include __DIR__ . '/../config.php';
// Basic auth for demo
session_start();
if (!isset($_SESSION['admin_logged'])) {
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && ($_POST['user'] ?? '') === $cfg['ADMIN_USER'] && ($_POST['pass'] ?? '') === $cfg['ADMIN_PASS']) {
        $_SESSION['admin_logged'] = true;
    } else {
        // Show login form
        echo '<!doctype html><html><head><meta charset="utf-8"><title>Admin Login</title></head><body>';
        echo '<h2>Admin Login</h2><form method="post"><label>User:<input name="user"></label><br><label>Pass:<input name="pass" type="password"></label><br><button type="submit">Login</button></form></body></html>';
        exit;
    }
}

$messages_file = $cfg['MESSAGES_FILE'];
$messages = [];
if (file_exists($messages_file)) $messages = json_decode(file_get_contents($messages_file), true) ?: [];
$settings = json_decode(file_get_contents($cfg['SETTINGS_FILE']), true);
$chatgpt_on = $settings['chatgpt_on'] ? 'ON' : 'OFF';
?>
<!doctype html>
<html>
<head><meta charset="utf-8"><title>Chat Agent Admin</title>
<style>
body{font-family: Arial, sans-serif; margin:20px;}
.conv{border:1px solid #ddd;padding:10px;margin:8px 0;}
.meta{color:#555;font-size:13px;}
.actions{margin-top:8px;}
</style>
</head>
<body>
<h1>Chat Agent - Admin</h1>
<p>ChatGPT status: <strong><?php echo $chatgpt_on; ?></strong> — <a href="toggle.php">Toggle</a></p>
<h2>Conversations</h2>
<?php if (!count($messages)) { echo '<p>No conversations yet.</p>'; } ?>
<?php foreach ($messages as $sender => $msgs): ?>
    <div class="conv">
        <div><strong>Sender:</strong> <?php echo htmlspecialchars($sender); ?></div>
        <div class="meta">Messages: <?php echo count($msgs); ?> | Last: <?php echo date('Y-m-d H:i:s', end($msgs)['timestamp'] ?? time()); ?></div>
        <div class="actions"><a href="chat.php?sender=<?php echo urlencode($sender); ?>">Open Chat</a></div>
    </div>
<?php endforeach; ?>
</body>
</html>
