<?php
// fb_send.php - helper to send messages via Facebook Send API
function fb_send_message($psid, $text, $cfg) {
    $token = $cfg['FB_PAGE_TOKEN'] ?? null;
    if (!$token) {
        error_log('FB_PAGE_TOKEN not set - message mocked. To: ' . $psid . ' Msg: ' . $text);
        return false;
    }
    $url = 'https://graph.facebook.com/v14.0/me/messages?access_token=' . urlencode($token);
    $payload = [
        'recipient' => ['id' => $psid],
        'message' => ['text' => $text]
    ];
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $resp = curl_exec($ch);
    $err = curl_error($ch);
    curl_close($ch);
    if ($resp === false) {
        error_log('FB send failed: ' . $err);
        return false;
    }
    return true;
}
?>
