<?php
// openai.php - helper to call OpenAI Chat Completions
function openai_chat_reply($prompt, $cfg) {
    $key = $cfg['OPENAI_KEY'] ?? null;
    if (!$key) return 'OpenAI key not set.';

    $payload = [
        'model' => 'gpt-4o-mini',
        'messages' => [
            ['role' => 'system', 'content' => 'You are an e-commerce assistant. Always reply concisely in Bangla.'],
            ['role' => 'user', 'content' => $prompt]
        ],
        'max_tokens' => 400,
        'temperature' => 0.2
    ];
    $ch = curl_init('https://api.openai.com/v1/chat/completions');
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, [
        'Content-Type: application/json',
        'Authorization: Bearer ' . $key
    ]);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
    curl_setopt($ch, CURLOPT_TIMEOUT, 20);
    $resp = curl_exec($ch);
    $err = curl_error($ch);
    curl_close($ch);
    if ($resp === false) return 'OpenAI request failed: ' . $err;
    $data = json_decode($resp, true);
    if (!isset($data['choices'][0]['message']['content'])) {
        return 'OpenAI returned unexpected response.';
    }
    $text = $data['choices'][0]['message']['content'];
    // Try to detect if it's JSON with reply_text; otherwise return as plain text
    $jsonStart = strpos($text, '{');
    if ($jsonStart !== false) {
        $maybe = substr($text, $jsonStart);
        $parsed = json_decode($maybe, true);
        if (is_array($parsed) && isset($parsed['reply_text'])) return $parsed;
    }
    return ['reply_text' => trim($text)];
}
?>
