<?php
// woo.php - minimal WooCommerce search via REST API (public 'search' parameter)
function woo_search_products($query, $cfg) {
    $base = rtrim($cfg['WC_BASE'], '/');
    $key = $cfg['WC_KEY'];
    $secret = $cfg['WC_SECRET'];
    if (!$base || !$key || !$secret) return [];

    $url = $base . '/products?search=' . urlencode($query) . '&per_page=5&consumer_key=' . urlencode($key) . '&consumer_secret=' . urlencode($secret);
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    $resp = curl_exec($ch);
    $err = curl_error($ch);
    curl_close($ch);
    if ($resp === false) return [];
    $data = json_decode($resp, true);
    if (!is_array($data)) return [];
    $out = [];
    foreach ($data as $p) {
        $out[] = [
            'id' => $p['id'] ?? null,
            'name' => $p['name'] ?? null,
            'price' => isset($p['price']) ? ($p['price'] . '৳') : null,
            'stock_status' => $p['stock_status'] ?? null,
            'permalink' => $p['permalink'] ?? null,
            'categories' => array_map(function($c){ return $c['name']; }, $p['categories'] ?? []),
            'images' => array_map(function($i){ return $i['src']; }, $p['images'] ?? [])
        ];
    }
    return $out;
}
?>
